const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');
const User = require('./models/admin/User');
require('dotenv').config();

async function updatePasswords() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });


    // New test passwords
    const newPasswords = {
      'admin@edumetrix.uk': 'EduAdmin2025!',
      'teacher@edumetrix.uk': 'TeachSecure99',
      'student@edumetrix.uk': 'StudentPass123'
    };

    for (const [username, newPassword] of Object.entries(newPasswords)) {
      const user = await User.findOne({ username });
      
      if (user) {
        const hashedPassword = await bcrypt.hash(newPassword, 10);
        user.password = hashedPassword;
        await user.save();
      } else {
      }
    }

    
    process.exit(0);
  } catch (error) {
    console.error('Error updating passwords:', error);
    process.exit(1);
  }
}

updatePasswords();