// Test setup and environment configuration
process.env.NODE_ENV = 'test';
process.env.JWT_SECRET = 'test_jwt_secret_for_testing_minimum_32_characters_long';
process.env.MONGODB_URI = 'mongodb://localhost:27017/edumetrix_test';

// Suppress console output during tests
global.console = {
  ...console,
  log: jest.fn(),
  error: jest.fn(),
  warn: jest.fn(),
  info: jest.fn(),
};

// Global test timeout
jest.setTimeout(30000);

// Clean up after tests
afterAll(async () => {
  // Close any remaining connections
  await new Promise(resolve => setTimeout(resolve, 500));
});