// services/messageService.js
import Chat from '../models/admin/Chat.js';

// services/messageService.js
async function sendMessage({ chatId, senderId, senderType, message, io }) {
  const chat = await Chat.findById(chatId);
  if (!chat) throw new Error('Chat not found');

  const isParticipant = chat.participants.some(p => p.userId.toString() === senderId.toString());
  if (!isParticipant) throw new Error('Not a participant');

  const newMsg = {
    senderId,
    senderType,
    message: message.substring(0, 500),
    timestamp: new Date()
  };

  chat.messages.push(newMsg);
  chat.lastActivity = new Date();

  // Increment unread count for the other participant
  chat.participants.forEach(p => {
    if (p.userId.toString() !== senderId.toString()) {
      p.unreadCount = (p.unreadCount || 0) + 1;
    }
  });

  await chat.save();

  // Emit new message to the room
  io.to(`chat-${chatId}`).emit('newMessage', {
    chatId,
    message: {
      ...newMsg,
      senderName: senderType === 'admin'
        ? 'Admin'
        : senderType === 'teacher'
          ? 'Teacher'
          : 'Student'
    }
  });

  // Emit updated unread count for recipient(s)
  chat.participants.forEach(p => {
    if (p.userId.toString() !== senderId.toString()) {
      io.to(`user-${p.userId}`).emit('chatUnreadUpdate', {
        chatId,
        unreadCount: p.unreadCount
      });
    }
  });

  return { newMsg, chat };
}


export { sendMessage };
