const mongoose = require('mongoose');
require('dotenv').config();

// Import all models
const Student = require('../models/student/Student');
const Teacher = require('../models/teacher/Teacher');
const User = require('../models/admin/User');
const Class = require('../models/Class');
const TeacherClass = require('../models/teacher/Class');
const TrialRequest = require('../models/admin/TrialRequest');

async function clearAllDummyData() {
  try {
    // Connect to MongoDB
    await mongoose.connect(process.env.MONGODB_URI);


    // Clear all collections
    const collections = [
      { model: Student, name: 'Students' },
      { model: Teacher, name: 'Teachers' },
      { model: User, name: 'Users' },
      { model: Class, name: 'Classes' },
      { model: TeacherClass, name: 'Teacher Classes' },
      { model: TrialRequest, name: 'Trial Requests' }
    ];

    for (const { model, name } of collections) {
      const count = await model.countDocuments();
      if (count > 0) {
        await model.deleteMany({});
      } else {
      }
    }

    // Create a fresh admin user for production
    const adminUser = new User({
      username: 'admin',
      password: '$2a$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', // password
      userType: 'admin',
      profile: {
        name: 'System Administrator',
        email: 'admin@edumetrix.com',
        position: 'System Administrator',
        department: 'Administration'
      },
      isActive: true
    });

    await adminUser.save();


  } catch (error) {
    console.error('❌ Error clearing dummy data:', error);
  } finally {
    await mongoose.connection.close();
    process.exit(0);
  }
}

// Run the cleanup
clearAllDummyData();