import express from 'express';
import { auth } from '../../middleware/advancedAuth.js';
import { createNotification } from '../../utils/notificationHelper.js';

const router = express.Router();

// Test endpoint to send a notification to yourself
router.post('/send-test', auth, async (req, res) => {
  try {
    const io = req.app.get('io');
    const userId = req.user._id;
    const userType = req.user.userType;

    console.log('🧪 TEST NOTIFICATION: Sending to user:', userId, 'type:', userType);

    const notification = await createNotification({
      userId,
      userType,
      type: 'general',
      title: 'Test Notification',
      message: `This is a test notification sent at ${new Date().toLocaleTimeString()}. If you see this in real-time, Socket.IO is working!`,
      priority: 'low',
      actionUrl: `/${userType}/dashboard`,
      io
    });

    res.json({
      success: true,
      message: 'Test notification sent successfully',
      data: {
        notificationId: notification._id,
        userId,
        userType,
        timestamp: new Date()
      }
    });

  } catch (error) {
    console.error('Test notification error:', error);
    res.status(500).json({
      success: false,
      message: 'Failed to send test notification',
      error: error.message
    });
  }
});

export default router;
