import mongoose from 'mongoose';

const chatSchema = new mongoose.Schema({
  participants: [{
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'User',
      required: true
    },
    userType: {
      type: String,
      enum: ['admin', 'teacher', 'student'],
      required: true
    },
        unreadCount: { type: Number, default: 0 } 

  }],
  messages: [{
    senderId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'User',
      required: true
    },
    senderType: {
      type: String,
      enum: ['admin', 'teacher', 'student'],
      required: true
    },
    message: {
      type: String,
      required: true
    },
    timestamp: {
      type: Date,
      default: Date.now
    },
    readBy: [{
      userId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
      },
      readAt: {
        type: Date,
        default: Date.now
      }
    }]
  }],
  chatType: {
    type: String,
    enum: ['student-teacher', 'student-admin', 'teacher-admin'],
    required: true
  },
  subject: {
    type: String,
    enum: ['Mathematics', 'General Science', 'Physics', 'Chemistry', 'Biology', 'English', 'Hindi', 'Computer Science', 'Arabic', 'Social Science', 'Geography', 'Malayalam', null],
    default: null
  },
  isActive: {
    type: Boolean,
    default: true
  },
  lastActivity: {
    type: Date,
    default: Date.now
  }
}, {
  timestamps: true
});

chatSchema.index({ createdAt: 1 }, { expireAfterSeconds: 2678400 });

export default mongoose.model('Chat', chatSchema);