// Legacy auth middleware - now redirects to secure advanced auth
import {
  auth as advancedAuth,
  requireAdmin,
  requireTeacher,
  requireStudent
} from './advancedAuth.js';

export const auth = advancedAuth;

export const adminAuth = (req, res, next) => {
  advancedAuth(req, res, (err) => {
    if (err) return next(err);
    requireAdmin(req, res, next);
  });
};

export const teacherAuth = (req, res, next) => {
  advancedAuth(req, res, (err) => {
    if (err) return next(err);
    requireTeacher(req, res, next);
  });
};

export const studentAuth = (req, res, next) => {
  advancedAuth(req, res, (err) => {
    if (err) return next(err);
    requireStudent(req, res, next);
  });
};