const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');
const User = require('./models/admin/User');
require('dotenv').config();

async function fixAdminPassword() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });


    const user = await User.findOne({ username: 'admin@edumetrix.uk' });
    
    if (user) {
      const newPassword = 'AdminPass2025';
      const hashedPassword = await bcrypt.hash(newPassword, 10);
      user.password = hashedPassword;
      await user.save();
    }

    
    process.exit(0);
  } catch (error) {
    console.error('Error:', error);
    process.exit(1);
  }
}

fixAdminPassword();