const getSyllabusOptions = (country) => {
  const syllabusMap = {
    'UAE': ['CBSE', 'ICSE', 'IGCSE', 'UK Syllabus'],
    'Saudi Arabia': ['CBSE', 'ICSE', 'IGCSE', 'UK Syllabus'],
    'Qatar': ['CBSE', 'ICSE', 'IGCSE', 'UK Syllabus'],
    'Kuwait': ['CBSE', 'ICSE', 'IGCSE', 'UK Syllabus'],
    'Bahrain': ['CBSE', 'ICSE', 'IGCSE', 'UK Syllabus'],
    'Oman': ['CBSE', 'ICSE', 'IGCSE', 'UK Syllabus'],
    'UK': ['National Curriculum'],
    'Australia': ['National Curriculum'],
    'New Zealand': ['National Curriculum'],
    'India': ['CBSE', 'ICSE', 'IGCSE']
  };
  
  return syllabusMap[country] || [];
};

const getCountryTimezone = (country) => {
  const timezoneMap = {
    'UAE': 'Asia/Dubai',
    'Saudi Arabia': 'Asia/Riyadh',
    'Qatar': 'Asia/Qatar',
    'Kuwait': 'Asia/Kuwait',
    'Bahrain': 'Asia/Bahrain',
    'Oman': 'Asia/Muscat',
    'UK': 'Europe/London',
    'Australia': 'Australia/Sydney',
    'New Zealand': 'Pacific/Auckland',
    'India': 'Asia/Kolkata'
  };
  
  return timezoneMap[country] || 'UTC';
};

export { getSyllabusOptions, getCountryTimezone };