const mongoose = require('mongoose');
const dotenv = require('dotenv');
const User = require('./models/admin/User');

// Load environment variables
dotenv.config();

const updateAdminName = async () => {
  try {
    // Connect to MongoDB
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });
    
    
    // Update all admin users to have EduMetrix name
    const result = await User.updateMany(
      { userType: 'admin' },
      { 
        $set: { 
          'profile.name': 'EduMetrix',
          'profile.position': 'EduMetrix',
          'profile.department': ''
        }
      }
    );
    
    
    // Verify the update
    const adminUsers = await User.find({ userType: 'admin' });
    adminUsers.forEach(user => {
    });
    
  } catch (error) {
    console.error('Error updating admin name:', error);
  } finally {
    await mongoose.disconnect();
  }
};

updateAdminName();