const { sendOTP, verifyOTP } = require('../../../services/emailService');

describe('Email Service Tests', () => {
  beforeEach(() => {
    // Clear any existing OTP data
    jest.clearAllMocks();
  });

  describe('sendOTP', () => {
    test('should accept authorized email', async () => {
      const result = await sendOTP('edumetrixuk@gmail.com');
      
      expect(result.success).toBe(true);
      expect(result.message).toContain('OTP');
    });

    test('should reject unauthorized email', async () => {
      await expect(sendOTP('unauthorized@example.com'))
        .rejects
        .toThrow('Unauthorized email address for admin access');
    });

    test('should generate 6-digit OTP', async () => {
      const result = await sendOTP('edumetrixuk@gmail.com');
      
      expect(result.success).toBe(true);
      // OTP should be stored in memory for verification
    });
  });

  describe('verifyOTP', () => {
    test('should verify correct OTP', async () => {
      // First send OTP
      await sendOTP('edumetrixuk@gmail.com');
      
      // Mock the OTP verification (since we can't access the actual OTP)
      // In a real test, you'd need access to the generated OTP
      const mockOTP = '123456';
      
      // This test would need to be adjusted based on how OTP storage is implemented
      expect(typeof mockOTP).toBe('string');
      expect(mockOTP.length).toBe(6);
    });

    test('should reject incorrect OTP', async () => {
      await sendOTP('edumetrixuk@gmail.com');
      
      const result = await verifyOTP('edumetrixuk@gmail.com', '000000');
      
      expect(result.success).toBe(false);
      expect(result.message).toContain('Invalid');
    });

    test('should reject expired OTP', async () => {
      // This test would require mocking time or waiting for OTP to expire
      // Implementation depends on OTP storage mechanism
      expect(true).toBe(true); // Placeholder
    });

    test('should limit OTP attempts', async () => {
      await sendOTP('edumetrixuk@gmail.com');
      
      // Try with wrong OTP multiple times
      for (let i = 0; i < 4; i++) {
        await verifyOTP('edumetrixuk@gmail.com', '000000');
      }
      
      // The 4th attempt should be blocked
      const result = await verifyOTP('edumetrixuk@gmail.com', '000000');
      expect(result.success).toBe(false);
    });
  });
});