#!/bin/bash

echo "🔵 Starting Admin Portal Only"
echo "============================="

# Start backend if not running
if ! pgrep -f "node server.js" > /dev/null; then
    echo "🔧 Starting Backend Server..."
    node server.js > server.log 2>&1 &
    sleep 3
fi

# Start Admin Portal
echo "🔵 Starting Admin Portal (Port 3001)..."
cd client
PORT=3001 REACT_APP_PORTAL_TYPE=admin npm start

# Open browser
if command -v open &> /dev/null; then
    sleep 3
    open http://localhost:3001
fi