import mongoose from 'mongoose';

const questionSchema = new mongoose.Schema({
  examId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Exam',
    required: true
  },
  questionText: {
    type: String,
    required: true,
    trim: true
  },
  options: [{
    optionId: {
      type: String,
      required: true
    },
    text: {
      type: String,
      required: true,
      trim: true
    },
    isCorrect: {
      type: Boolean,
      default: false
    }
  }],
  marks: {
    type: Number,
    required: true,
    default: 1
  },
  order: {
    type: Number,
    required: true
  },
  createdAt: {
    type: Date,
    default: Date.now
  },
  updatedAt: {
    type: Date,
    default: Date.now
  }
});

questionSchema.pre('save', function(next) {
  this.updatedAt = Date.now();
  
  const correctOptions = this.options.filter(opt => opt.isCorrect);
  if (correctOptions.length !== 1) {
    return next(new Error('Exactly one option must be marked as correct'));
  }
  
  if (this.options.length !== 4) {
    return next(new Error('Each question must have exactly 4 options'));
  }
  
  next();
});

export default mongoose.model('Question', questionSchema);