import mongoose from 'mongoose';

const conversationSchema = new mongoose.Schema({
  participants: [
    {
      userId: { type: mongoose.Schema.Types.ObjectId, required: true },
      userType: { type: String, enum: ['Admin', 'Teacher', 'Student'], required: true },
    },
  ],
  isGroup: { type: Boolean, default: false }, // True for group chats
  isVisibleToAdmin: { type: Boolean, default: false }, // Allow Admin to see all teacher-student messages

  createdAt: { type: Date, default: Date.now },
  updatedAt: { type: Date, default: Date.now },
}, {
  timestamps: true, // Automatically manage createdAt and updatedAt
});

const Conversation = mongoose.model('Conversation', conversationSchema);

export default  Conversation;
