#!/bin/bash

echo "🎓 EduMetrix UK Platform - Development Setup"
echo "============================================="
echo ""

# Function to check if a command exists
command_exists() {
    command -v "$1" >/dev/null 2>&1
}

# Check for Node.js
if ! command_exists node; then
    echo "❌ Node.js is not installed. Please install Node.js first."
    echo "   Download from: https://nodejs.org/"
    exit 1
fi

# Check for npm
if ! command_exists npm; then
    echo "❌ npm is not installed. Please install npm first."
    exit 1
fi

echo "✅ Node.js version: $(node --version)"
echo "✅ npm version: $(npm --version)"
echo ""

# Install backend dependencies
echo "📦 Installing backend dependencies..."
npm install

if [ $? -ne 0 ]; then
    echo "❌ Failed to install backend dependencies"
    exit 1
fi

echo "✅ Backend dependencies installed"
echo ""

# Install frontend dependencies
echo "📦 Installing frontend dependencies..."
cd client
npm install

if [ $? -ne 0 ]; then
    echo "❌ Failed to install frontend dependencies"
    exit 1
fi

cd ..
echo "✅ Frontend dependencies installed"
echo ""

# Make shell scripts executable
echo "🔧 Setting up executable permissions..."
chmod +x start-all-portals.sh
chmod +x start-admin.sh
chmod +x start-teacher.sh
chmod +x start-student.sh
chmod +x setup.sh

echo "✅ Permissions set"
echo ""

echo "🎉 Setup Complete!"
echo "=================="
echo ""
echo "🚀 To start all three portals in development mode:"
echo "   ./start-all-portals.sh"
echo ""
echo "🔗 Portal URLs (will open automatically):"
echo "   Admin Portal:   http://localhost:3001"
echo "   Teacher Portal: http://localhost:3002"
echo "   Student Portal: http://localhost:3003"
echo ""
echo "⚡ All portals will auto-login in development mode"
echo "📝 No login required - direct access to dashboards"
echo ""
echo "🛑 To stop all portals: Press Ctrl+C in the terminal"
echo ""