const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');
const User = require('./models/admin/User');
require('dotenv').config();

async function createAdmin() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });


    // Check if admin already exists
    const existingAdmin = await User.findOne({ username: 'kaarysathan' });
    if (existingAdmin) {
      console.log('Admin user already exists with username: kaarysathan');
      // Update password if needed
      const hashedPassword = await bcrypt.hash('testadmin123', 10);
      existingAdmin.password = hashedPassword;
      existingAdmin.isActive = true;
      existingAdmin.isDeleted = false;
      await existingAdmin.save();
      console.log('Admin password updated successfully');
      process.exit(0);
    }

    // Create admin user
    const hashedPassword = await bcrypt.hash('testadmin123', 10);
    
    const adminUser = new User({
      username: 'kaarysathan',
      password: hashedPassword,
      userType: 'admin',
      profile: {
        name: 'Kaarysathan',
        email: 'admin@edumetrix.uk',
        position: 'System Administrator',
        department: 'Administration',
        profilePicture: null
      },
      isActive: true,
      isDeleted: false
    });

    await adminUser.save();
    console.log('Admin user created successfully');
    console.log('Username: kaarysathan');
    console.log('Password: testadmin123');
    
    process.exit(0);
  } catch (error) {
    console.error('Error creating admin:', error);
    process.exit(1);
  }
}

createAdmin();