const mongoose = require('mongoose');
const TrialRequest = require('./models/admin/TrialRequest');
const Teacher = require('./models/teacher/Teacher'); // Import Teacher model
require('dotenv').config();

async function checkTrialRequests() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });

    console.log('\n=== Trial Requests Check ===\n');
    
    // Count all trial requests
    const totalRequests = await TrialRequest.countDocuments();
    console.log('Total trial requests in database:', totalRequests);
    
    // List all trial requests
    console.log('\nAll trial requests:');
    const allRequests = await TrialRequest.find()
      .populate('assignedTeacher', 'name')
      .sort({ createdAt: -1 });
    
    if (allRequests.length === 0) {
      console.log('No trial requests found in database');
    } else {
      allRequests.forEach((request, index) => {
        console.log(`\n${index + 1}. ${request.studentName}`);
        console.log(`   Parent: ${request.parentName}`);
        console.log(`   Email: ${request.email}`);
        console.log(`   Status: ${request.status}`);
        console.log(`   Created: ${request.createdAt}`);
        console.log(`   Assigned Teacher: ${request.assignedTeacher?.name || 'None'}`);
      });
    }
    
    // Count by status
    console.log('\n=== Requests by Status ===');
    const statuses = ['pending', 'scheduled', 'completed', 'converted', 'cancelled'];
    for (const status of statuses) {
      const count = await TrialRequest.countDocuments({ status });
      console.log(`${status}: ${count}`);
    }
    
    process.exit(0);
  } catch (error) {
    console.error('Error:', error);
    process.exit(1);
  }
}

checkTrialRequests();