# 🎓 EduMetrix Platform - Portal Access Guide

## ✅ All Portals Are Now Running!

### 🔗 Portal URLs:
- **🔵 Admin Portal:** http://localhost:3001
- **🟢 Teacher Portal:** http://localhost:3002  
- **🟣 Student Portal:** http://localhost:3003
- **🔧 Backend API:** https://backend.edumetrix.uk

### 🔐 Login Credentials:

#### Admin Portal (localhost:3001)
- **Username:** admin@edumetrix.uk
- **Password:** AdminPass2025

#### Teacher Portal (localhost:3002)
- **Username:** teacher@edumetrix.uk
- **Password:** TeachSecure99

#### Student Portal (localhost:3003)  
- **Username:** student@edumetrix.uk
- **Password:** StudentPass123

## 🚀 How to Start All Portals:

```bash
cd "/Users/abcom/Desktop/EduMetrix UK/Platform"
./start-all-portals.sh
```

## 🛑 How to Stop All Services:
Press `Ctrl+C` in the terminal running the portals, or:
```bash
pkill -f "PORT=300"
pkill -f "node server.js"
```

## 📱 What Each Portal Contains:

### Admin Portal Features:
- Student Management (Create, Edit, View)
- Teacher Management (Create, Edit, View)
- Class Scheduling & Calendar
- Finance Dashboard & Invoicing
- Reports & Analytics
- System Settings

### Teacher Portal Features:
- Teacher Dashboard
- My Classes & Schedule
- Student Management
- Assignment Creation & Grading
- Attendance Tracking
- Reports

### Student Portal Features:
- Student Dashboard
- My Classes & Schedule  
- Homework & Assignments
- Attendance Reports
- Invoices & Payments
- Chat with Teachers

## 🔧 Technical Details:
- **Backend:** Node.js + Express + MongoDB (Port 5001)
- **Frontend:** React + Material-UI (Ports 3001, 3002, 3003)
- **Database:** MongoDB (localhost:27017)
- **All APIs:** Fully functional and tested ✅

## 🌐 Browser Access:
Each portal will automatically open in your browser when you run the startup script. You can also manually visit the URLs above.

---
**Note:** All portals are fully functional with real backend APIs - no mock data!